<?php
include 'db.php'; // Include your database connection file

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Create the `images/banner` directory if it doesn't exist
$upload_dir = 'images/banner/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Initialize variables
$position = $_POST['position'] ?? null;
$redirect_link = $_POST['Redircet_link'] ?? null;
$active = isset($_POST['active']) ? (int)$_POST['active'] : 0;



// Handle file uploads and save paths
$web_image_path = uploadFile('Web_Image', $upload_dir);
$mobile_banner_path = uploadFile('Mobile_banner', $upload_dir);
$tab_banner_path = uploadFile('Tab_banner', $upload_dir);

// Check if all files were uploaded successfully
if (!$web_image_path || !$mobile_banner_path || !$tab_banner_path) {
    echo json_encode(["status" => "error", "message" => "Failed to upload one or more images"]);
    exit;
}

// Insert data into the `banner` table
$insert_query = "
    INSERT INTO banner (Web_Image, Mobile_banner, Tab_banner, Redircet_link, position, active, Delete_status)
    VALUES ('$web_image_path', '$mobile_banner_path', '$tab_banner_path', '$redirect_link', '$position', '$active', 0)
";

if (mysqli_query($conn, $insert_query)) {
    echo json_encode(["status" => "success", "message" => "Banner added successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert banner"]);
}

// Function to handle file upload
function uploadFile($file_key, $upload_dir) {
    if (isset($_FILES[$file_key]) && $_FILES[$file_key]['error'] === UPLOAD_ERR_OK) {
        $file_name = basename($_FILES[$file_key]['name']);
        $file_tmp = $_FILES[$file_key]['tmp_name'];
        $file_path = $upload_dir . uniqid() . '_' . $file_name;

        if (move_uploaded_file($file_tmp, $file_path)) {
            return $file_path;
        }
    }
    return null; // Return null if the file upload fails
}
?>
